# Ćwiczenie 1

## Zadanie
Utwórz funkcję generującą oprogramowanie pośredniczące, która będzie tworzyła kontekst razem z licznikiem czasu. Funkcja powinna mieć jeden parametr — liczba milisekund, przez które żądanie może być wykonywane. Wartością zwrotną tej funkcji ma być `func(http.Handler) http.Handler`.

## Rozwiązanie
To jest nieco trudniejsze ćwiczenie, ponieważ trzeba utworzyć funkcję zwracającą funkcję, która również zwraca funkcję (ach!). Funkcja +Timeout+ przedstawia się następująco:

```go
func Timeout(ms int) func(http.Handler) http.Handler {
    return func(h http.Handler) http.Handler {
        return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
            ctx := r.Context()
            ctx, cancelFunc := context.WithTimeout(ctx, time.Duration(ms)*time.Millisecond)
            defer cancelFunc()
            r = r.WithContext(ctx)
            h.ServeHTTP(w, r)
        })
    }
}
```

Sygnatura odpowiada opisowi problemu. Funkcja zawiera zadeklarowane dwie funkcje zagnieżdżone. Funkcją zewnętrzną jest `func(h http.Handler) http.Handler`, która zwraca funkcję `func(w http.ResponseWriter, r *http.Request)` konwertowaną na typ `http.HandlerFunc`, spełniający wymagania interfejsu `http.Handler`.

Funkcja wewnętrzna wykonuje całą właściwą pracę. Następuje wyodrębnienie kontekstu z żądania, opakowanie go kontekstem wygenerowanym przez wywołanie +context.WithTimeout+, wywołanie +cancelFunc+ razem z +defer+, przygotowanie zamiennika `*http.Request` z użyciem nowego kontekstu i starego żądania z metodą `WithContext` w starym żądaniu, a następnie wywołanie metody `ServeHTTP` w instancji `http.Handler` przekazanej do oprogramowania pośredniczącego.

Zwróć uwagę na brak w tym rozwiązaniu kod gwarantującego, że nie zostanie przekroczony czas działania. Za to odpowiada żądanie i jego logika biznesowa. 

Uchwyt żądania powinien mieć kod w postaci podobnej do tutaj przedstawionej:

```go
func sleepy(w http.ResponseWriter, r *http.Request) {
	ctx := r.Context()
	message, err := doThing(ctx)
	if err != nil {
		if errors.Is(err, context.DeadlineExceeded) {
			w.WriteHeader(http.StatusGatewayTimeout)
		} else {
			w.WriteHeader(http.StatusInternalServerError)
		}
	} else {
		w.WriteHeader(http.StatusOK)
	}
	w.Write([]byte(message))
}
```

Logika biznesowa powinna zawierać kod sprawdzający kontekst, aby mieć pewność, że operacja nie zabierze zbyt dużo czasu.

```go
func doThing(ctx context.Context) (string, error) {
	wait := rand.Intn(200)
	select {
	case <-time.After(time.Duration(wait) * time.Millisecond):
		return "Done!", nil
	case <-ctx.Done():
		return "Too slow!", ctx.Err()
	}
}
```